#include <cstdio>
#include <vector>
#include <algorithm>

const int INF = 1e9;
const int MAXM = 1000000;
const int MAXD = 20;
const int MAXN = 1001000;

int n;
int d;
std::vector<int> e[MAXN];
int dp[MAXN][3];

void rec(int x, int depth) {
  if (depth == d) {
    for (int i = 0; i < 3; ++i) {
      dp[x][i] = e[x].size() + i;
    }
    return;
  }
  for (auto y : e[x]) {
    rec(y, depth + 1);
  }

  auto calc = [&](int c) {
    if (e[x].size() < 2U) return INF;
    std::vector<int> costs;
    for (auto y : e[x]) {
      int best = INF;
      for (int i = c; i < 3; ++i) {
        best = std::min(best, dp[y][i] + i - c);
      }
      costs.push_back(best);
    }
    std::partial_sort(costs.begin(), costs.begin() + 2, costs.end());
    return std::min(INF, costs[0] + costs[1] + (int)e[x].size() - 2);
  };

  dp[x][0] = calc(0);
  e[x].push_back(MAXM + d - depth - 1);
  dp[x][1] = calc(1);
  e[x].push_back(MAXM + MAXD + d - depth - 1);
  dp[x][2] = calc(2);
}

int main() {
  int n;
  scanf("%d%d", &n, &d);
  for (int i = 0; i < n - 1; ++i) {
    int a;
    scanf("%d", &a);
    e[a - 1].push_back(i + 1);
  }

  for (int i = 0; i < d; ++i) {
    dp[MAXM + i][0] = INF;
    dp[MAXM + i][1] = i == 0 ? 0 : (1 << (i + 1)) - 1;
    dp[MAXM + i][2] = i == 0 ? 1 : (1 << (i + 1)) - 2;

    dp[MAXM + MAXD + i][0] = INF;
    dp[MAXM + MAXD + i][1] = INF;
    dp[MAXM + MAXD + i][2] = i == 0 ? 0 : (1 << (i + 1)) - 1;
  }

  rec(0, 0);

  int res = INF;
  for (int i = 0; i < 3; ++i) {
    res = std::min(res, dp[0][i] + i);
  }
  printf("%d\n", res);
  return 0;
}
